function [residual, g1, g2, g3] = World_Economy_Competitive_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(33, 1);
T14 = (params(2)-1)/params(2);
T17 = exp(T14*y(42));
T22 = exp(y(13))^params(3);
T26 = exp(y(37))^(1-params(3));
T27 = T22*T26;
T28 = T27^T14;
T34 = (1-params(11))*T17*T28+params(11)*exp(y(32))^T14;
T41 = exp(y(35))^(1/params(2));
T43 = (-1)/params(2);
T44 = exp(y(32))^T43;
T52 = T27^T43;
T56 = exp(y(37))^(-params(3));
T66 = exp(y(13))^(params(3)-1);
T118 = params(9)^((-1)/params(8));
T124 = exp(y(57));
T138 = exp(y(38))-params(9)*exp(y(37))^(1+params(8))/(1+params(8));
T142 = params(1)*T138^(-params(14));
T150 = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T151 = T150^(-params(14));
T186 = params(13)^(1-params(4));
T216 = T124*(exp(y(51))*exp((-y(58)))*exp(y(27))+(1-exp((-y(58)))*exp(y(27)))*y(54)-params(6)*exp(params(5)*(y(27)-y(58))));
T228 = params(12)^(1-params(4));
lhs =exp(y(35));
rhs =T34^(params(2)/(params(2)-1));
residual(1)= lhs-rhs;
lhs =exp(y(18));
rhs =params(11)*T41*T44;
residual(2)= lhs-rhs;
lhs =exp(y(40));
rhs =T22*T41*T17*(1-params(11))*(1-params(3))*T52*T56;
residual(3)= lhs-rhs;
lhs =exp(y(39));
rhs =T26*T52*T41*T17*(1-params(11))*params(3)*T66;
residual(4)= lhs-rhs;
lhs =exp(y(29));
rhs =T17*exp(y(13)*params(3))*exp(y(37)*(1-params(3)));
residual(5)= lhs-rhs;
lhs =exp(y(38))+exp(y(36))+exp(y(20))+exp(y(19))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(43)))*exp(y(6));
rhs =exp(y(35))+exp(y(13))*(1-params(10));
residual(6)= lhs-rhs;
lhs =exp(y(37));
rhs =T118*exp(y(40))^(1/params(8));
residual(7)= lhs-rhs;
lhs =1;
rhs =T124*(1+exp(y(56))-params(10));
residual(8)= lhs-rhs;
lhs =exp(y(41));
rhs =T142/T151;
residual(9)= lhs-rhs;
lhs =y(30);
rhs =T124*(exp(y(28))*exp(y(51))+(1-exp(y(28)))*y(52)-params(6)*exp(params(5)*y(28)));
residual(10)= lhs-rhs;
lhs =y(31);
rhs =y(30)*params(7)+T124*(1-params(7))*y(53);
residual(11)= lhs-rhs;
lhs =y(31)*params(4)*exp(y(20)*(params(4)-1))*T186;
rhs =1;
residual(12)= lhs-rhs;
lhs =T124*params(6)*params(5)*exp(y(28)*(params(5)-1));
rhs =T124*(exp(y(51))-y(52));
residual(13)= lhs-rhs;
lhs =y(33);
rhs =T216;
residual(14)= lhs-rhs;
lhs =y(34);
rhs =params(7)*y(33)+T124*(1-params(7))*y(55);
residual(15)= lhs-rhs;
lhs =y(34)*params(4)*exp(y(19)*(params(4)-1))*T228;
rhs =1;
residual(16)= lhs-rhs;
lhs =T124*params(6)*params(5)*exp((params(5)-1)*y(27))*exp(y(58)*(-params(5)));
rhs =T124*exp((-y(58)))*(exp(y(51))-y(54));
residual(17)= lhs-rhs;
lhs =exp(y(24));
rhs =exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(26));
residual(18)= lhs-rhs;
lhs =exp(y(23));
rhs =exp(y(6))*(1-exp((-y(43)))*exp(y(10)))+params(7)*exp(y(25));
residual(19)= lhs-rhs;
lhs =exp(y(26));
rhs =(1-params(7))*exp(y(9))+T186*exp(y(20)*params(4));
residual(20)= lhs-rhs;
lhs =exp(y(25));
rhs =(1-params(7))*exp(y(8))+T228*exp(y(19)*params(4));
residual(21)= lhs-rhs;
lhs =exp(y(22));
rhs =exp(y(7))*exp(y(11));
residual(22)= lhs-rhs;
lhs =exp(y(21));
rhs =exp(y(6))*exp((-y(43)))*exp(y(10));
residual(23)= lhs-rhs;
lhs =exp(y(32));
rhs =exp(y(22))+exp(y(21));
residual(24)= lhs-rhs;
lhs =y(43);
rhs =x(it_, 1);
residual(25)= lhs-rhs;
lhs =y(42);
rhs =x(it_, 2)+params(15)*y(16)+params(16)*y(17);
residual(26)= lhs-rhs;
lhs =y(44);
rhs =y(18)-y(1);
residual(27)= lhs-rhs;
lhs =y(45);
rhs =y(20)-y(3);
residual(28)= lhs-rhs;
lhs =y(46);
rhs =y(19)-y(2);
residual(29)= lhs-rhs;
lhs =y(47);
rhs =y(22)-y(5);
residual(30)= lhs-rhs;
lhs =y(48);
rhs =y(21)-y(4);
residual(31)= lhs-rhs;
lhs =y(49);
rhs =y(35)-y(12);
residual(32)= lhs-rhs;
lhs =y(50);
rhs =y(16);
residual(33)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(33, 60);

  %
  % Jacobian matrix
  %

T362 = (-(exp(y(6))*exp((-y(43)))*exp(y(10))));
T377 = exp(y(51))*exp((-y(58)))*exp(y(27))+y(54)*(-(exp((-y(58)))*exp(y(27))));
T382 = (-(T124*(T377-params(6)*params(5)*exp(params(5)*(y(27)-y(58))))));
T410 = exp(y(32))*getPowerDeriv(exp(y(32)),T14,1);
T412 = getPowerDeriv(T34,params(2)/(params(2)-1),1);
T416 = exp(y(32))*getPowerDeriv(exp(y(32)),T43,1);
T423 = exp(y(35))*getPowerDeriv(exp(y(35)),1/params(2),1);
T439 = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T441 = getPowerDeriv(T27,T14,1);
T446 = getPowerDeriv(T27,T43,1);
T456 = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T468 = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T471 = (-(params(9)*T468/(1+params(8))));
T472 = getPowerDeriv(T150,(-params(14)),1);
T480 = exp(y(37))*getPowerDeriv(exp(y(37)),1-params(3),1);
T481 = T22*T480;
T490 = exp(y(37))*getPowerDeriv(exp(y(37)),(-params(3)),1);
T505 = exp(y(37))*getPowerDeriv(exp(y(37)),1+params(8),1);
T508 = (-(params(9)*T505/(1+params(8))));
T509 = getPowerDeriv(T138,(-params(14)),1);
T511 = params(1)*T508*T509;
T526 = exp(y(40))*getPowerDeriv(exp(y(40)),1/params(8),1);
T577 = (-(T124*(exp(y(51))*exp(y(27))*(-exp((-y(58))))+y(54)*(-(exp(y(27))*(-exp((-y(58))))))-params(6)*exp(params(5)*(y(27)-y(58)))*(-params(5)))));
T583 = T124*params(6)*params(5)*exp((params(5)-1)*y(27))*(-params(5))*exp(y(58)*(-params(5)))-(exp(y(51))-y(54))*T124*(-exp((-y(58))));
  g1(1,32)=(-(params(11)*T410*T412));
  g1(1,35)=exp(y(35));
  g1(1,13)=(-(T412*(1-params(11))*T17*T26*T439*T441));
  g1(1,37)=(-(T412*(1-params(11))*T17*T441*T481));
  g1(1,42)=(-(T412*T28*(1-params(11))*T14*T17));
  g1(2,18)=exp(y(18));
  g1(2,32)=(-(params(11)*T41*T416));
  g1(2,35)=(-(T44*params(11)*T423));
  g1(3,35)=(-(T56*T22*T52*T17*(1-params(11))*(1-params(3))*T423));
  g1(3,13)=(-(T56*(T41*T17*(1-params(11))*(1-params(3))*T52*T439+T22*T41*T17*(1-params(11))*(1-params(3))*T26*T439*T446)));
  g1(3,37)=(-(T56*T22*T41*T17*(1-params(11))*(1-params(3))*T446*T481+T22*T41*T17*(1-params(11))*(1-params(3))*T52*T490));
  g1(3,40)=exp(y(40));
  g1(3,42)=(-(T56*T22*T52*T41*(1-params(11))*(1-params(3))*T14*T17));
  g1(4,35)=(-(T26*T66*T52*T17*(1-params(11))*params(3)*T423));
  g1(4,13)=(-(T26*(T66*T41*T17*(1-params(11))*params(3)*T26*T439*T446+T52*T41*T17*(1-params(11))*params(3)*T456)));
  g1(4,37)=(-(T52*T41*T17*(1-params(11))*params(3)*T66*T480+T26*T66*T41*T17*(1-params(11))*params(3)*T446*T481));
  g1(4,39)=exp(y(39));
  g1(4,42)=(-(T26*T66*T52*T41*(1-params(11))*params(3)*T14*T17));
  g1(5,29)=exp(y(29));
  g1(5,13)=(-(exp(y(37)*(1-params(3)))*T17*params(3)*exp(y(13)*params(3))));
  g1(5,37)=(-(T17*exp(y(13)*params(3))*(1-params(3))*exp(y(37)*(1-params(3)))));
  g1(5,42)=(-(exp(y(37)*(1-params(3)))*exp(y(13)*params(3))*T14*T17));
  g1(6,19)=exp(y(19));
  g1(6,20)=exp(y(20));
  g1(6,6)=params(6)*exp(params(5)*(y(10)-y(43)))*exp(y(6));
  g1(6,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
  g1(6,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(43)));
  g1(6,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
  g1(6,35)=(-exp(y(35)));
  g1(6,13)=(-(exp(y(13))*(1-params(10))));
  g1(6,36)=exp(y(36));
  g1(6,38)=exp(y(38));
  g1(6,43)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(43)))*(-params(5));
  g1(7,37)=exp(y(37));
  g1(7,40)=(-(T118*T526));
  g1(8,56)=(-(T124*exp(y(56))));
  g1(8,57)=(-(T124*(1+exp(y(56))-params(10))));
  g1(9,14)=(-((-(T142*T471*T472))/(T151*T151)));
  g1(9,37)=(-(T511/T151));
  g1(9,15)=(-((-(T142*exp(y(15))*T472))/(T151*T151)));
  g1(9,38)=(-(params(1)*exp(y(38))*T509/T151));
  g1(9,41)=exp(y(41));
  g1(10,51)=(-(T124*exp(y(28))*exp(y(51))));
  g1(10,28)=(-(T124*(exp(y(28))*exp(y(51))+y(52)*(-exp(y(28)))-params(6)*params(5)*exp(params(5)*y(28)))));
  g1(10,30)=1;
  g1(10,52)=(-(T124*(1-exp(y(28)))));
  g1(10,57)=(-(T124*(exp(y(28))*exp(y(51))+(1-exp(y(28)))*y(52)-params(6)*exp(params(5)*y(28)))));
  g1(11,30)=(-params(7));
  g1(11,31)=1;
  g1(11,53)=(-(T124*(1-params(7))));
  g1(11,57)=(-(T124*(1-params(7))*y(53)));
  g1(12,20)=y(31)*T186*params(4)*(params(4)-1)*exp(y(20)*(params(4)-1));
  g1(12,31)=params(4)*exp(y(20)*(params(4)-1))*T186;
  g1(13,51)=(-(T124*exp(y(51))));
  g1(13,28)=T124*params(6)*params(5)*(params(5)-1)*exp(y(28)*(params(5)-1));
  g1(13,52)=T124;
  g1(13,57)=T124*params(6)*params(5)*exp(y(28)*(params(5)-1))-T124*(exp(y(51))-y(52));
  g1(14,51)=(-(T124*exp(y(51))*exp((-y(58)))*exp(y(27))));
  g1(14,27)=T382;
  g1(14,33)=1;
  g1(14,54)=(-(T124*(1-exp((-y(58)))*exp(y(27)))));
  g1(14,57)=(-T216);
  g1(14,58)=T577;
  g1(15,33)=(-params(7));
  g1(15,34)=1;
  g1(15,55)=(-(T124*(1-params(7))));
  g1(15,57)=(-(T124*(1-params(7))*y(55)));
  g1(16,19)=y(34)*T228*params(4)*(params(4)-1)*exp(y(19)*(params(4)-1));
  g1(16,34)=params(4)*exp(y(19)*(params(4)-1))*T228;
  g1(17,51)=(-(exp(y(51))*T124*exp((-y(58)))));
  g1(17,27)=T124*exp(y(58)*(-params(5)))*params(6)*params(5)*(params(5)-1)*exp((params(5)-1)*y(27));
  g1(17,54)=T124*exp((-y(58)));
  g1(17,57)=T124*params(6)*params(5)*exp((params(5)-1)*y(27))*exp(y(58)*(-params(5)))-T124*exp((-y(58)))*(exp(y(51))-y(54));
  g1(17,58)=T583;
  g1(18,7)=(-(exp(y(7))*(1-exp(y(11)))));
  g1(18,24)=exp(y(24));
  g1(18,26)=(-(params(7)*exp(y(26))));
  g1(18,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(19,6)=(-(exp(y(6))*(1-exp((-y(43)))*exp(y(10)))));
  g1(19,23)=exp(y(23));
  g1(19,25)=(-(params(7)*exp(y(25))));
  g1(19,10)=(-(exp(y(6))*(-(exp((-y(43)))*exp(y(10))))));
  g1(19,43)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(43))))))));
  g1(20,20)=(-(T186*params(4)*exp(y(20)*params(4))));
  g1(20,9)=(-((1-params(7))*exp(y(9))));
  g1(20,26)=exp(y(26));
  g1(21,19)=(-(T228*params(4)*exp(y(19)*params(4))));
  g1(21,8)=(-((1-params(7))*exp(y(8))));
  g1(21,25)=exp(y(25));
  g1(22,22)=exp(y(22));
  g1(22,7)=(-(exp(y(7))*exp(y(11))));
  g1(22,11)=(-(exp(y(7))*exp(y(11))));
  g1(23,21)=exp(y(21));
  g1(23,6)=T362;
  g1(23,10)=T362;
  g1(23,43)=(-(exp(y(6))*exp(y(10))*(-exp((-y(43))))));
  g1(24,21)=(-exp(y(21)));
  g1(24,22)=(-exp(y(22)));
  g1(24,32)=exp(y(32));
  g1(25,43)=1;
  g1(25,59)=(-1);
  g1(26,16)=(-params(15));
  g1(26,42)=1;
  g1(26,60)=(-1);
  g1(26,17)=(-params(16));
  g1(27,1)=1;
  g1(27,18)=(-1);
  g1(27,44)=1;
  g1(28,3)=1;
  g1(28,20)=(-1);
  g1(28,45)=1;
  g1(29,2)=1;
  g1(29,19)=(-1);
  g1(29,46)=1;
  g1(30,5)=1;
  g1(30,22)=(-1);
  g1(30,47)=1;
  g1(31,4)=1;
  g1(31,21)=(-1);
  g1(31,48)=1;
  g1(32,12)=1;
  g1(32,35)=(-1);
  g1(32,49)=1;
  g1(33,16)=(-1);
  g1(33,50)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(223,3);
T590 = getPowerDeriv(T34,params(2)/(params(2)-1),2);
T591 = params(11)*T410*T590;
T602 = T439+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T604 = getPowerDeriv(T27,T14,2);
T605 = T26*T439*T604;
T630 = T480+exp(y(37))*exp(y(37))*getPowerDeriv(exp(y(37)),1-params(3),2);
T631 = T22*T630;
T671 = T423+exp(y(35))*exp(y(35))*getPowerDeriv(exp(y(35)),1/params(2),2);
T689 = getPowerDeriv(T27,T43,2);
T690 = T26*T439*T689;
T869 = getPowerDeriv(T150,(-params(14)),2);
T870 = T471*T869;
T895 = getPowerDeriv(T138,(-params(14)),2);
T896 = T508*T895;
  v2(1,1)=1;
  v2(1,2)=1892;
  v2(1,3)=(-(T412*params(11)*(T410+exp(y(32))*exp(y(32))*getPowerDeriv(exp(y(32)),T14,2))+params(11)*T410*T591));
  v2(2,1)=1;
  v2(2,2)=2075;
  v2(2,3)=exp(y(35));
  v2(3,1)=1;
  v2(3,2)=752;
  v2(3,3)=(-((1-params(11))*T17*T26*T439*T441*T591));
  v2(4,1)=1;
  v2(4,2)=1873;
  v2(4,3)=  v2(3,3);
  v2(5,1)=1;
  v2(5,2)=733;
  v2(5,3)=(-((1-params(11))*T17*T26*T439*T441*(1-params(11))*T17*T26*T439*T441*T590+T412*(1-params(11))*T17*(T441*T26*T602+T26*T439*T605)));
  v2(6,1)=1;
  v2(6,2)=2192;
  v2(6,3)=(-((1-params(11))*T17*T441*T481*T591));
  v2(7,1)=1;
  v2(7,2)=1897;
  v2(7,3)=  v2(6,3);
  v2(8,1)=1;
  v2(8,2)=2173;
  v2(8,3)=(-((1-params(11))*T17*T441*T481*(1-params(11))*T17*T26*T439*T441*T590+T412*(1-params(11))*T17*(T481*T605+T441*T439*T480)));
  v2(9,1)=1;
  v2(9,2)=757;
  v2(9,3)=  v2(8,3);
  v2(10,1)=1;
  v2(10,2)=2197;
  v2(10,3)=(-((1-params(11))*T17*T441*T481*(1-params(11))*T17*T441*T481*T590+T412*(1-params(11))*T17*(T481*T481*T604+T441*T631)));
  v2(11,1)=1;
  v2(11,2)=2492;
  v2(11,3)=(-(T28*(1-params(11))*T14*T17*T591));
  v2(12,1)=1;
  v2(12,2)=1902;
  v2(12,3)=  v2(11,3);
  v2(13,1)=1;
  v2(13,2)=2473;
  v2(13,3)=(-(T28*(1-params(11))*T14*T17*(1-params(11))*T17*T26*T439*T441*T590+T412*T26*T439*T441*(1-params(11))*T14*T17));
  v2(14,1)=1;
  v2(14,2)=762;
  v2(14,3)=  v2(13,3);
  v2(15,1)=1;
  v2(15,2)=2497;
  v2(15,3)=(-(T28*(1-params(11))*T14*T17*(1-params(11))*T17*T441*T481*T590+T412*T441*T481*(1-params(11))*T14*T17));
  v2(16,1)=1;
  v2(16,2)=2202;
  v2(16,3)=  v2(15,3);
  v2(17,1)=1;
  v2(17,2)=2502;
  v2(17,3)=(-(T28*(1-params(11))*T14*T17*T28*(1-params(11))*T14*T17*T590+T412*T28*(1-params(11))*T14*T14*T17));
  v2(18,1)=2;
  v2(18,2)=1038;
  v2(18,3)=exp(y(18));
  v2(19,1)=2;
  v2(19,2)=1892;
  v2(19,3)=(-(params(11)*T41*(T416+exp(y(32))*exp(y(32))*getPowerDeriv(exp(y(32)),T43,2))));
  v2(20,1)=2;
  v2(20,2)=2072;
  v2(20,3)=(-(T416*params(11)*T423));
  v2(21,1)=2;
  v2(21,2)=1895;
  v2(21,3)=  v2(20,3);
  v2(22,1)=2;
  v2(22,2)=2075;
  v2(22,3)=(-(T44*params(11)*T671));
  v2(23,1)=3;
  v2(23,2)=2075;
  v2(23,3)=(-(T56*T22*T52*T17*(1-params(11))*(1-params(3))*T671));
  v2(24,1)=3;
  v2(24,2)=755;
  v2(24,3)=(-(T56*(T52*T17*(1-params(11))*(1-params(3))*T423*T439+T22*T17*(1-params(11))*(1-params(3))*T423*T26*T439*T446)));
  v2(25,1)=3;
  v2(25,2)=2053;
  v2(25,3)=  v2(24,3);
  v2(26,1)=3;
  v2(26,2)=733;
  v2(26,3)=(-(T56*(T439*T41*T17*(1-params(11))*(1-params(3))*T26*T439*T446+T41*T17*(1-params(11))*(1-params(3))*T52*T602+T439*T41*T17*(1-params(11))*(1-params(3))*T26*T439*T446+T22*T41*T17*(1-params(11))*(1-params(3))*(T446*T26*T602+T26*T439*T690))));
  v2(27,1)=3;
  v2(27,2)=2195;
  v2(27,3)=(-(T56*T22*T17*(1-params(11))*(1-params(3))*T423*T446*T481+T22*T52*T17*(1-params(11))*(1-params(3))*T423*T490));
  v2(28,1)=3;
  v2(28,2)=2077;
  v2(28,3)=  v2(27,3);
  v2(29,1)=3;
  v2(29,2)=2173;
  v2(29,3)=(-(T56*(T439*T41*T17*(1-params(11))*(1-params(3))*T446*T481+T22*T41*T17*(1-params(11))*(1-params(3))*(T481*T690+T446*T439*T480))+(T41*T17*(1-params(11))*(1-params(3))*T52*T439+T22*T41*T17*(1-params(11))*(1-params(3))*T26*T439*T446)*T490));
  v2(30,1)=3;
  v2(30,2)=757;
  v2(30,3)=  v2(29,3);
  v2(31,1)=3;
  v2(31,2)=2197;
  v2(31,3)=(-(T22*T41*T17*(1-params(11))*(1-params(3))*T446*T481*T490+T56*T22*T41*T17*(1-params(11))*(1-params(3))*(T481*T481*T689+T446*T631)+T22*T41*T17*(1-params(11))*(1-params(3))*T446*T481*T490+T22*T41*T17*(1-params(11))*(1-params(3))*T52*(T490+exp(y(37))*exp(y(37))*getPowerDeriv(exp(y(37)),(-params(3)),2))));
  v2(32,1)=3;
  v2(32,2)=2380;
  v2(32,3)=exp(y(40));
  v2(33,1)=3;
  v2(33,2)=2495;
  v2(33,3)=(-(T56*T22*T52*T423*(1-params(11))*(1-params(3))*T14*T17));
  v2(34,1)=3;
  v2(34,2)=2082;
  v2(34,3)=  v2(33,3);
  v2(35,1)=3;
  v2(35,2)=2473;
  v2(35,3)=(-(T56*(T439*T52*T41*(1-params(11))*(1-params(3))*T14*T17+T22*T26*T439*T446*T41*(1-params(11))*(1-params(3))*T14*T17)));
  v2(36,1)=3;
  v2(36,2)=762;
  v2(36,3)=  v2(35,3);
  v2(37,1)=3;
  v2(37,2)=2497;
  v2(37,3)=(-(T490*T22*T52*T41*(1-params(11))*(1-params(3))*T14*T17+T56*T22*T446*T481*T41*(1-params(11))*(1-params(3))*T14*T17));
  v2(38,1)=3;
  v2(38,2)=2202;
  v2(38,3)=  v2(37,3);
  v2(39,1)=3;
  v2(39,2)=2502;
  v2(39,3)=(-(T56*T22*T52*T41*(1-params(11))*(1-params(3))*T14*T14*T17));
  v2(40,1)=4;
  v2(40,2)=2075;
  v2(40,3)=(-(T26*T66*T52*T17*(1-params(11))*params(3)*T671));
  v2(41,1)=4;
  v2(41,2)=755;
  v2(41,3)=(-(T26*(T66*T17*(1-params(11))*params(3)*T423*T26*T439*T446+T52*T17*(1-params(11))*params(3)*T423*T456)));
  v2(42,1)=4;
  v2(42,2)=2053;
  v2(42,3)=  v2(41,3);
  v2(43,1)=4;
  v2(43,2)=733;
  v2(43,3)=(-(T26*(T41*T17*(1-params(11))*params(3)*T26*T439*T446*T456+T66*T41*T17*(1-params(11))*params(3)*(T446*T26*T602+T26*T439*T690)+T41*T17*(1-params(11))*params(3)*T26*T439*T446*T456+T52*T41*T17*(1-params(11))*params(3)*(T456+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2)))));
  v2(44,1)=4;
  v2(44,2)=2195;
  v2(44,3)=(-(T66*T52*T17*(1-params(11))*params(3)*T423*T480+T26*T66*T17*(1-params(11))*params(3)*T423*T446*T481));
  v2(45,1)=4;
  v2(45,2)=2077;
  v2(45,3)=  v2(44,3);
  v2(46,1)=4;
  v2(46,2)=2173;
  v2(46,3)=(-((T66*T41*T17*(1-params(11))*params(3)*T26*T439*T446+T52*T41*T17*(1-params(11))*params(3)*T456)*T480+T26*(T456*T41*T17*(1-params(11))*params(3)*T446*T481+T66*T41*T17*(1-params(11))*params(3)*(T481*T690+T446*T439*T480))));
  v2(47,1)=4;
  v2(47,2)=757;
  v2(47,3)=  v2(46,3);
  v2(48,1)=4;
  v2(48,2)=2197;
  v2(48,3)=(-(T480*T66*T41*T17*(1-params(11))*params(3)*T446*T481+T52*T41*T17*(1-params(11))*params(3)*T66*T630+T480*T66*T41*T17*(1-params(11))*params(3)*T446*T481+T26*T66*T41*T17*(1-params(11))*params(3)*(T481*T481*T689+T446*T631)));
  v2(49,1)=4;
  v2(49,2)=2319;
  v2(49,3)=exp(y(39));
  v2(50,1)=4;
  v2(50,2)=2495;
  v2(50,3)=(-(T26*T66*T52*T423*(1-params(11))*params(3)*T14*T17));
  v2(51,1)=4;
  v2(51,2)=2082;
  v2(51,3)=  v2(50,3);
  v2(52,1)=4;
  v2(52,2)=2473;
  v2(52,3)=(-(T26*(T456*T52*T41*(1-params(11))*params(3)*T14*T17+T66*T26*T439*T446*T41*(1-params(11))*params(3)*T14*T17)));
  v2(53,1)=4;
  v2(53,2)=762;
  v2(53,3)=  v2(52,3);
  v2(54,1)=4;
  v2(54,2)=2497;
  v2(54,3)=(-(T480*T66*T52*T41*(1-params(11))*params(3)*T14*T17+T26*T66*T446*T481*T41*(1-params(11))*params(3)*T14*T17));
  v2(55,1)=4;
  v2(55,2)=2202;
  v2(55,3)=  v2(54,3);
  v2(56,1)=4;
  v2(56,2)=2502;
  v2(56,3)=(-(T26*T66*T52*T41*(1-params(11))*params(3)*T14*T14*T17));
  v2(57,1)=5;
  v2(57,2)=1709;
  v2(57,3)=exp(y(29));
  v2(58,1)=5;
  v2(58,2)=733;
  v2(58,3)=(-(exp(y(37)*(1-params(3)))*T17*params(3)*params(3)*exp(y(13)*params(3))));
  v2(59,1)=5;
  v2(59,2)=2173;
  v2(59,3)=(-(T17*params(3)*exp(y(13)*params(3))*(1-params(3))*exp(y(37)*(1-params(3)))));
  v2(60,1)=5;
  v2(60,2)=757;
  v2(60,3)=  v2(59,3);
  v2(61,1)=5;
  v2(61,2)=2197;
  v2(61,3)=(-(T17*exp(y(13)*params(3))*(1-params(3))*(1-params(3))*exp(y(37)*(1-params(3)))));
  v2(62,1)=5;
  v2(62,2)=2473;
  v2(62,3)=(-(exp(y(37)*(1-params(3)))*params(3)*exp(y(13)*params(3))*T14*T17));
  v2(63,1)=5;
  v2(63,2)=762;
  v2(63,3)=  v2(62,3);
  v2(64,1)=5;
  v2(64,2)=2497;
  v2(64,3)=(-((1-params(3))*exp(y(37)*(1-params(3)))*exp(y(13)*params(3))*T14*T17));
  v2(65,1)=5;
  v2(65,2)=2202;
  v2(65,3)=  v2(64,3);
  v2(66,1)=5;
  v2(66,2)=2502;
  v2(66,3)=(-(exp(y(37)*(1-params(3)))*exp(y(13)*params(3))*T14*T14*T17));
  v2(67,1)=6;
  v2(67,2)=1099;
  v2(67,3)=exp(y(19));
  v2(68,1)=6;
  v2(68,2)=1160;
  v2(68,3)=exp(y(20));
  v2(69,1)=6;
  v2(69,2)=306;
  v2(69,3)=params(6)*exp(params(5)*(y(10)-y(43)))*exp(y(6));
  v2(70,1)=6;
  v2(70,2)=367;
  v2(70,3)=params(6)*exp(params(5)*y(11))*exp(y(7));
  v2(71,1)=6;
  v2(71,2)=546;
  v2(71,3)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(43)));
  v2(72,1)=6;
  v2(72,2)=310;
  v2(72,3)=  v2(71,3);
  v2(73,1)=6;
  v2(73,2)=550;
  v2(73,3)=exp(y(6))*params(6)*params(5)*params(5)*exp(params(5)*(y(10)-y(43)));
  v2(74,1)=6;
  v2(74,2)=607;
  v2(74,3)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
  v2(75,1)=6;
  v2(75,2)=371;
  v2(75,3)=  v2(74,3);
  v2(76,1)=6;
  v2(76,2)=611;
  v2(76,3)=exp(y(7))*params(6)*params(5)*params(5)*exp(params(5)*y(11));
  v2(77,1)=6;
  v2(77,2)=2075;
  v2(77,3)=(-exp(y(35)));
  v2(78,1)=6;
  v2(78,2)=733;
  v2(78,3)=(-(exp(y(13))*(1-params(10))));
  v2(79,1)=6;
  v2(79,2)=2136;
  v2(79,3)=exp(y(36));
  v2(80,1)=6;
  v2(80,2)=2258;
  v2(80,3)=exp(y(38));
  v2(81,1)=6;
  v2(81,2)=2526;
  v2(81,3)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(43)))*(-params(5));
  v2(82,1)=6;
  v2(82,2)=343;
  v2(82,3)=  v2(81,3);
  v2(83,1)=6;
  v2(83,2)=2530;
  v2(83,3)=exp(y(6))*params(6)*(-params(5))*params(5)*exp(params(5)*(y(10)-y(43)));
  v2(84,1)=6;
  v2(84,2)=583;
  v2(84,3)=  v2(83,3);
  v2(85,1)=6;
  v2(85,2)=2563;
  v2(85,3)=exp(y(6))*params(6)*(-params(5))*exp(params(5)*(y(10)-y(43)))*(-params(5));
  v2(86,1)=7;
  v2(86,2)=2197;
  v2(86,3)=exp(y(37));
  v2(87,1)=7;
  v2(87,2)=2380;
  v2(87,3)=(-(T118*(T526+exp(y(40))*exp(y(40))*getPowerDeriv(exp(y(40)),1/params(8),2))));
  v2(88,1)=8;
  v2(88,2)=3356;
  v2(88,3)=(-(T124*exp(y(56))));
  v2(89,1)=8;
  v2(89,2)=3416;
  v2(89,3)=(-(T124*exp(y(56))));
  v2(90,1)=8;
  v2(90,2)=3357;
  v2(90,3)=  v2(89,3);
  v2(91,1)=8;
  v2(91,2)=3417;
  v2(91,3)=(-(T124*(1+exp(y(56))-params(10))));
  v2(92,1)=9;
  v2(92,2)=794;
  v2(92,3)=(-((T151*T151*(-(T142*(T472*(-(params(9)*(T468+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T471*T870)))-(-(T142*T471*T472))*(T151*T471*T472+T151*T471*T472))/(T151*T151*T151*T151)));
  v2(93,1)=9;
  v2(93,2)=2174;
  v2(93,3)=(-((-(T471*T472*T511))/(T151*T151)));
  v2(94,1)=9;
  v2(94,2)=817;
  v2(94,3)=  v2(93,3);
  v2(95,1)=9;
  v2(95,2)=2197;
  v2(95,3)=(-(params(1)*(T509*(-(params(9)*(T505+exp(y(37))*exp(y(37))*getPowerDeriv(exp(y(37)),1+params(8),2))/(1+params(8))))+T508*T896)/T151));
  v2(96,1)=9;
  v2(96,2)=854;
  v2(96,3)=(-((T151*T151*(-(T142*exp(y(15))*T870))-(-(T142*exp(y(15))*T472))*(T151*T471*T472+T151*T471*T472))/(T151*T151*T151*T151)));
  v2(97,1)=9;
  v2(97,2)=795;
  v2(97,3)=  v2(96,3);
  v2(98,1)=9;
  v2(98,2)=877;
  v2(98,3)=(-((-(T511*exp(y(15))*T472))/(T151*T151)));
  v2(99,1)=9;
  v2(99,2)=2175;
  v2(99,3)=  v2(98,3);
  v2(100,1)=9;
  v2(100,2)=855;
  v2(100,3)=(-((T151*T151*(-(T142*(exp(y(15))*T472+exp(y(15))*exp(y(15))*T869)))-(-(T142*exp(y(15))*T472))*(T151*exp(y(15))*T472+T151*exp(y(15))*T472))/(T151*T151*T151*T151)));
  v2(101,1)=9;
  v2(101,2)=2234;
  v2(101,3)=(-((-(T471*T472*params(1)*exp(y(38))*T509))/(T151*T151)));
  v2(102,1)=9;
  v2(102,2)=818;
  v2(102,3)=  v2(101,3);
  v2(103,1)=9;
  v2(103,2)=2257;
  v2(103,3)=(-(params(1)*exp(y(38))*T896/T151));
  v2(104,1)=9;
  v2(104,2)=2198;
  v2(104,3)=  v2(103,3);
  v2(105,1)=9;
  v2(105,2)=2235;
  v2(105,3)=(-((-(exp(y(15))*T472*params(1)*exp(y(38))*T509))/(T151*T151)));
  v2(106,1)=9;
  v2(106,2)=878;
  v2(106,3)=  v2(105,3);
  v2(107,1)=9;
  v2(107,2)=2258;
  v2(107,3)=(-(params(1)*(exp(y(38))*T509+exp(y(38))*exp(y(38))*T895)/T151));
  v2(108,1)=9;
  v2(108,2)=2441;
  v2(108,3)=exp(y(41));
  v2(109,1)=10;
  v2(109,2)=3051;
  v2(109,3)=(-(T124*exp(y(28))*exp(y(51))));
  v2(110,1)=10;
  v2(110,2)=1671;
  v2(110,3)=(-(T124*exp(y(28))*exp(y(51))));
  v2(111,1)=10;
  v2(111,2)=3028;
  v2(111,3)=  v2(110,3);
  v2(112,1)=10;
  v2(112,2)=1648;
  v2(112,3)=(-(T124*(exp(y(28))*exp(y(51))+y(52)*(-exp(y(28)))-params(6)*params(5)*params(5)*exp(params(5)*y(28)))));
  v2(113,1)=10;
  v2(113,2)=3088;
  v2(113,3)=(-(T124*(-exp(y(28)))));
  v2(114,1)=10;
  v2(114,2)=1672;
  v2(114,3)=  v2(113,3);
  v2(115,1)=10;
  v2(115,2)=3411;
  v2(115,3)=(-(T124*exp(y(28))*exp(y(51))));
  v2(116,1)=10;
  v2(116,2)=3057;
  v2(116,3)=  v2(115,3);
  v2(117,1)=10;
  v2(117,2)=3388;
  v2(117,3)=(-(T124*(exp(y(28))*exp(y(51))+y(52)*(-exp(y(28)))-params(6)*params(5)*exp(params(5)*y(28)))));
  v2(118,1)=10;
  v2(118,2)=1677;
  v2(118,3)=  v2(117,3);
  v2(119,1)=10;
  v2(119,2)=3412;
  v2(119,3)=(-(T124*(1-exp(y(28)))));
  v2(120,1)=10;
  v2(120,2)=3117;
  v2(120,3)=  v2(119,3);
  v2(121,1)=10;
  v2(121,2)=3417;
  v2(121,3)=(-(T124*(exp(y(28))*exp(y(51))+(1-exp(y(28)))*y(52)-params(6)*exp(params(5)*y(28)))));
  v2(122,1)=11;
  v2(122,2)=3413;
  v2(122,3)=(-(T124*(1-params(7))));
  v2(123,1)=11;
  v2(123,2)=3177;
  v2(123,3)=  v2(122,3);
  v2(124,1)=11;
  v2(124,2)=3417;
  v2(124,3)=(-(T124*(1-params(7))*y(53)));
  v2(125,1)=12;
  v2(125,2)=1160;
  v2(125,3)=y(31)*T186*params(4)*(params(4)-1)*(params(4)-1)*exp(y(20)*(params(4)-1));
  v2(126,1)=12;
  v2(126,2)=1820;
  v2(126,3)=T186*params(4)*(params(4)-1)*exp(y(20)*(params(4)-1));
  v2(127,1)=12;
  v2(127,2)=1171;
  v2(127,3)=  v2(126,3);
  v2(128,1)=13;
  v2(128,2)=3051;
  v2(128,3)=(-(T124*exp(y(51))));
  v2(129,1)=13;
  v2(129,2)=1648;
  v2(129,3)=T124*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(28)*(params(5)-1));
  v2(130,1)=13;
  v2(130,2)=3411;
  v2(130,3)=(-(T124*exp(y(51))));
  v2(131,1)=13;
  v2(131,2)=3057;
  v2(131,3)=  v2(130,3);
  v2(132,1)=13;
  v2(132,2)=3388;
  v2(132,3)=T124*params(6)*params(5)*(params(5)-1)*exp(y(28)*(params(5)-1));
  v2(133,1)=13;
  v2(133,2)=1677;
  v2(133,3)=  v2(132,3);
  v2(134,1)=13;
  v2(134,2)=3412;
  v2(134,3)=T124;
  v2(135,1)=13;
  v2(135,2)=3117;
  v2(135,3)=  v2(134,3);
  v2(136,1)=13;
  v2(136,2)=3417;
  v2(136,3)=T124*params(6)*params(5)*exp(y(28)*(params(5)-1))-T124*(exp(y(51))-y(52));
  v2(137,1)=14;
  v2(137,2)=3051;
  v2(137,3)=(-(T124*exp(y(51))*exp((-y(58)))*exp(y(27))));
  v2(138,1)=14;
  v2(138,2)=1611;
  v2(138,3)=(-(T124*exp(y(51))*exp((-y(58)))*exp(y(27))));
  v2(139,1)=14;
  v2(139,2)=3027;
  v2(139,3)=  v2(138,3);
  v2(140,1)=14;
  v2(140,2)=1587;
  v2(140,3)=(-(T124*(T377-params(6)*params(5)*params(5)*exp(params(5)*(y(27)-y(58))))));
  v2(141,1)=14;
  v2(141,2)=3207;
  v2(141,3)=(-(T124*(-(exp((-y(58)))*exp(y(27))))));
  v2(142,1)=14;
  v2(142,2)=1614;
  v2(142,3)=  v2(141,3);
  v2(143,1)=14;
  v2(143,2)=3411;
  v2(143,3)=(-(T124*exp(y(51))*exp((-y(58)))*exp(y(27))));
  v2(144,1)=14;
  v2(144,2)=3057;
  v2(144,3)=  v2(143,3);
  v2(145,1)=14;
  v2(145,2)=3387;
  v2(145,3)=T382;
  v2(146,1)=14;
  v2(146,2)=1617;
  v2(146,3)=  v2(145,3);
  v2(147,1)=14;
  v2(147,2)=3414;
  v2(147,3)=(-(T124*(1-exp((-y(58)))*exp(y(27)))));
  v2(148,1)=14;
  v2(148,2)=3237;
  v2(148,3)=  v2(147,3);
  v2(149,1)=14;
  v2(149,2)=3417;
  v2(149,3)=(-T216);
  v2(150,1)=14;
  v2(150,2)=3471;
  v2(150,3)=(-(T124*exp(y(51))*exp(y(27))*(-exp((-y(58))))));
  v2(151,1)=14;
  v2(151,2)=3058;
  v2(151,3)=  v2(150,3);
  v2(152,1)=14;
  v2(152,2)=3447;
  v2(152,3)=(-(T124*(exp(y(51))*exp(y(27))*(-exp((-y(58))))+y(54)*(-(exp(y(27))*(-exp((-y(58))))))-params(6)*(-params(5))*params(5)*exp(params(5)*(y(27)-y(58))))));
  v2(153,1)=14;
  v2(153,2)=1618;
  v2(153,3)=  v2(152,3);
  v2(154,1)=14;
  v2(154,2)=3474;
  v2(154,3)=(-(T124*(-(exp(y(27))*(-exp((-y(58))))))));
  v2(155,1)=14;
  v2(155,2)=3238;
  v2(155,3)=  v2(154,3);
  v2(156,1)=14;
  v2(156,2)=3477;
  v2(156,3)=T577;
  v2(157,1)=14;
  v2(157,2)=3418;
  v2(157,3)=  v2(156,3);
  v2(158,1)=14;
  v2(158,2)=3478;
  v2(158,3)=(-(T124*(T377-params(6)*(-params(5))*exp(params(5)*(y(27)-y(58)))*(-params(5)))));
  v2(159,1)=15;
  v2(159,2)=3415;
  v2(159,3)=(-(T124*(1-params(7))));
  v2(160,1)=15;
  v2(160,2)=3297;
  v2(160,3)=  v2(159,3);
  v2(161,1)=15;
  v2(161,2)=3417;
  v2(161,3)=(-(T124*(1-params(7))*y(55)));
  v2(162,1)=16;
  v2(162,2)=1099;
  v2(162,3)=y(34)*T228*params(4)*(params(4)-1)*(params(4)-1)*exp(y(19)*(params(4)-1));
  v2(163,1)=16;
  v2(163,2)=1999;
  v2(163,3)=T228*params(4)*(params(4)-1)*exp(y(19)*(params(4)-1));
  v2(164,1)=16;
  v2(164,2)=1114;
  v2(164,3)=  v2(163,3);
  v2(165,1)=17;
  v2(165,2)=3051;
  v2(165,3)=(-(exp(y(51))*T124*exp((-y(58)))));
  v2(166,1)=17;
  v2(166,2)=1587;
  v2(166,3)=T124*exp(y(58)*(-params(5)))*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp((params(5)-1)*y(27));
  v2(167,1)=17;
  v2(167,2)=3411;
  v2(167,3)=(-(exp(y(51))*T124*exp((-y(58)))));
  v2(168,1)=17;
  v2(168,2)=3057;
  v2(168,3)=  v2(167,3);
  v2(169,1)=17;
  v2(169,2)=3387;
  v2(169,3)=T124*exp(y(58)*(-params(5)))*params(6)*params(5)*(params(5)-1)*exp((params(5)-1)*y(27));
  v2(170,1)=17;
  v2(170,2)=1617;
  v2(170,3)=  v2(169,3);
  v2(171,1)=17;
  v2(171,2)=3414;
  v2(171,3)=T124*exp((-y(58)));
  v2(172,1)=17;
  v2(172,2)=3237;
  v2(172,3)=  v2(171,3);
  v2(173,1)=17;
  v2(173,2)=3417;
  v2(173,3)=T124*params(6)*params(5)*exp((params(5)-1)*y(27))*exp(y(58)*(-params(5)))-T124*exp((-y(58)))*(exp(y(51))-y(54));
  v2(174,1)=17;
  v2(174,2)=3471;
  v2(174,3)=(-(exp(y(51))*T124*(-exp((-y(58))))));
  v2(175,1)=17;
  v2(175,2)=3058;
  v2(175,3)=  v2(174,3);
  v2(176,1)=17;
  v2(176,2)=3447;
  v2(176,3)=T124*params(6)*params(5)*(params(5)-1)*exp((params(5)-1)*y(27))*(-params(5))*exp(y(58)*(-params(5)));
  v2(177,1)=17;
  v2(177,2)=1618;
  v2(177,3)=  v2(176,3);
  v2(178,1)=17;
  v2(178,2)=3474;
  v2(178,3)=T124*(-exp((-y(58))));
  v2(179,1)=17;
  v2(179,2)=3238;
  v2(179,3)=  v2(178,3);
  v2(180,1)=17;
  v2(180,2)=3477;
  v2(180,3)=T583;
  v2(181,1)=17;
  v2(181,2)=3418;
  v2(181,3)=  v2(180,3);
  v2(182,1)=17;
  v2(182,2)=3478;
  v2(182,3)=T124*params(6)*params(5)*exp((params(5)-1)*y(27))*(-params(5))*(-params(5))*exp(y(58)*(-params(5)))-T124*exp((-y(58)))*(exp(y(51))-y(54));
  v2(183,1)=18;
  v2(183,2)=367;
  v2(183,3)=(-(exp(y(7))*(1-exp(y(11)))));
  v2(184,1)=18;
  v2(184,2)=1404;
  v2(184,3)=exp(y(24));
  v2(185,1)=18;
  v2(185,2)=1526;
  v2(185,3)=(-(params(7)*exp(y(26))));
  v2(186,1)=18;
  v2(186,2)=607;
  v2(186,3)=(-(exp(y(7))*(-exp(y(11)))));
  v2(187,1)=18;
  v2(187,2)=371;
  v2(187,3)=  v2(186,3);
  v2(188,1)=18;
  v2(188,2)=611;
  v2(188,3)=(-(exp(y(7))*(-exp(y(11)))));
  v2(189,1)=19;
  v2(189,2)=306;
  v2(189,3)=(-(exp(y(6))*(1-exp((-y(43)))*exp(y(10)))));
  v2(190,1)=19;
  v2(190,2)=1343;
  v2(190,3)=exp(y(23));
  v2(191,1)=19;
  v2(191,2)=1465;
  v2(191,3)=(-(params(7)*exp(y(25))));
  v2(192,1)=19;
  v2(192,2)=546;
  v2(192,3)=(-(exp(y(6))*(-(exp((-y(43)))*exp(y(10))))));
  v2(193,1)=19;
  v2(193,2)=310;
  v2(193,3)=  v2(192,3);
  v2(194,1)=19;
  v2(194,2)=550;
  v2(194,3)=(-(exp(y(6))*(-(exp((-y(43)))*exp(y(10))))));
  v2(195,1)=19;
  v2(195,2)=2526;
  v2(195,3)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(43))))))));
  v2(196,1)=19;
  v2(196,2)=343;
  v2(196,3)=  v2(195,3);
  v2(197,1)=19;
  v2(197,2)=2530;
  v2(197,3)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(43))))))));
  v2(198,1)=19;
  v2(198,2)=583;
  v2(198,3)=  v2(197,3);
  v2(199,1)=19;
  v2(199,2)=2563;
  v2(199,3)=(-(exp(y(6))*(-(exp((-y(43)))*exp(y(10))))));
  v2(200,1)=20;
  v2(200,2)=1160;
  v2(200,3)=(-(T186*params(4)*params(4)*exp(y(20)*params(4))));
  v2(201,1)=20;
  v2(201,2)=489;
  v2(201,3)=(-((1-params(7))*exp(y(9))));
  v2(202,1)=20;
  v2(202,2)=1526;
  v2(202,3)=exp(y(26));
  v2(203,1)=21;
  v2(203,2)=1099;
  v2(203,3)=(-(T228*params(4)*params(4)*exp(y(19)*params(4))));
  v2(204,1)=21;
  v2(204,2)=428;
  v2(204,3)=(-((1-params(7))*exp(y(8))));
  v2(205,1)=21;
  v2(205,2)=1465;
  v2(205,3)=exp(y(25));
  v2(206,1)=22;
  v2(206,2)=1282;
  v2(206,3)=exp(y(22));
  v2(207,1)=22;
  v2(207,2)=367;
  v2(207,3)=(-(exp(y(7))*exp(y(11))));
  v2(208,1)=22;
  v2(208,2)=607;
  v2(208,3)=(-(exp(y(7))*exp(y(11))));
  v2(209,1)=22;
  v2(209,2)=371;
  v2(209,3)=  v2(208,3);
  v2(210,1)=22;
  v2(210,2)=611;
  v2(210,3)=(-(exp(y(7))*exp(y(11))));
  v2(211,1)=23;
  v2(211,2)=1221;
  v2(211,3)=exp(y(21));
  v2(212,1)=23;
  v2(212,2)=306;
  v2(212,3)=T362;
  v2(213,1)=23;
  v2(213,2)=546;
  v2(213,3)=T362;
  v2(214,1)=23;
  v2(214,2)=310;
  v2(214,3)=  v2(213,3);
  v2(215,1)=23;
  v2(215,2)=550;
  v2(215,3)=T362;
  v2(216,1)=23;
  v2(216,2)=2526;
  v2(216,3)=(-(exp(y(6))*exp(y(10))*(-exp((-y(43))))));
  v2(217,1)=23;
  v2(217,2)=343;
  v2(217,3)=  v2(216,3);
  v2(218,1)=23;
  v2(218,2)=2530;
  v2(218,3)=(-(exp(y(6))*exp(y(10))*(-exp((-y(43))))));
  v2(219,1)=23;
  v2(219,2)=583;
  v2(219,3)=  v2(218,3);
  v2(220,1)=23;
  v2(220,2)=2563;
  v2(220,3)=T362;
  v2(221,1)=24;
  v2(221,2)=1221;
  v2(221,3)=(-exp(y(21)));
  v2(222,1)=24;
  v2(222,2)=1282;
  v2(222,3)=(-exp(y(22)));
  v2(223,1)=24;
  v2(223,2)=1892;
  v2(223,3)=exp(y(32));
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),33,3600);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],33,216000);
end
end
end
end
